% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/out.objects.R
\name{heatmap,pairwisefst-method}
\alias{heatmap,pairwisefst-method}
\title{Show pairwisefst object}
\usage{
\S4method{heatmap}{pairwisefst}(
  x,
  Rowv = NULL,
  Colv = if (symm) "Rowv" else NULL,
  distfun = as.dist,
  hclustfun = hclust,
  reorderfun = function(d, w) reorder(d, w),
  add.expr,
  symm = FALSE,
  revC = identical(Colv, "Rowv"),
  scale = c("row", "column", "none"),
  na.rm = TRUE,
  margins = c(5, 5),
  ColSideColors,
  RowSideColors,
  cexRow = 0.2 + 1/log10(nrow(x@PairwiseFSTmatrix)),
  cexCol = 0.2 + 1/log10(ncol(x@PairwiseFSTmatrix)),
  labRow = NULL,
  labCol = NULL,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  keep.dendro = FALSE,
  verbose = getOption("verbose"),
  ...
)
}
\arguments{
\item{x}{Object of class pairwisefst}

\item{Rowv}{determines if and how the row dendrogram should be computed and reordered. Either a dendrogram or a vector of values used to reorder the row dendrogram or NA to suppress any row dendrogram (and reordering) or by default, NULL, see ‘Details’ below.}

\item{Colv}{determines if and how the column dendrogram should be reordered. Has the same options as the Rowv argument above and additionally when x is a square matrix, Colv = "Rowv" means that columns should be treated identically to the rows (and so if there is to be no row dendrogram there will not be a column one either).}

\item{distfun}{function used to compute the distance (dissimilarity) between both rows and columns. Defaults to as.dist.}

\item{hclustfun}{function used to compute the hierarchical clustering when Rowv or Colv are not dendrograms. Defaults to hclust. Should take as argument a result of distfun and return an object to which as.dendrogram can be applied.}

\item{reorderfun}{function(d, w) of dendrogram and weights for reordering the row and column dendrograms. The default uses reorder.dendrogram.}

\item{add.expr}{expression that will be evaluated after the call to image. Can be used to add components to the plot.}

\item{symm}{logical indicating if x should be treated symmetrically; can only be true when x is a square matrix.}

\item{revC}{logical indicating if the column order should be reversed for plotting, such that e.g., for the symmetric case, the symmetry axis is as usual.}

\item{scale}{character indicating if the values should be centered and scaled in either the row direction or the column direction, or none. The default is "row" if symm false, and "none" otherwise.}

\item{na.rm}{logical indicating whether NA's should be removed.}

\item{margins}{numeric vector of length 2 containing the margins (see par(mar = *)) for column and row names, respectively.}

\item{ColSideColors}{(optional) character vector of length ncol(x) containing the color names for a horizontal side bar that may be used to annotate the columns of x.}

\item{RowSideColors}{(optional) character vector of length nrow(x) containing the color names for a vertical side bar that may be used to annotate the rows of x.}

\item{cexRow, cexCol}{positive numbers, used as cex.axis in for the row or column axis labeling. The defaults currently only use number of rows or columns, respectively.}

\item{labRow, labCol}{character vectors with row and column labels to use; these default to rownames(x) or colnames(x), respectively.}

\item{main, xlab, ylab}{main, x- and y-axis titles; defaults to none.}

\item{keep.dendro}{logical indicating if the dendrogram(s) should be kept as part of the result (when Rowv and/or Colv are not NA).}

\item{verbose}{logical indicating if information should be printed.}

\item{...}{additional arguments passed on to image, e.g., col specifying the colors.}
}
\description{
Show pairwisefst object
}
