% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitwise.r
\name{samp.ia}
\alias{samp.ia}
\title{Calculate random samples of the index of association for genlight objects.}
\usage{
samp.ia(x, n.snp = 100L, reps = 100L, threads = 1L, quiet = FALSE)
}
\arguments{
\item{x}{a genlight object.}

\item{n.snp}{the number of snps to be used to calculate standardized index
of association.}

\item{reps}{the number of times to perform the calculation.}

\item{threads}{The maximum number of parallel threads to be used within this 
function. A value of 0 (default) will attempt to use as many threads as
there are available cores/CPUs. In most cases this is ideal. A value of 1
will force the function to run serially, which may increase stability on
some systems. Other values may be specified, but should be used with
caution.}

\item{quiet}{if \code{FALSE}, a progress bar will be printed to the screen.}
}
\value{
Index of association representing the samples in this genlight
  object.
}
\description{
Genlight objects can contain millions of loci. Since it does not make much 
sense to calculate the index of association over that many loci, this
function will randomly sample sites to calculate the index of association.
}
\note{
this will calculate the standardized index of association from Agapow
2001. See \code{\link{ia}} for details.
}
\examples{
\dontrun{
# with structured snps assuming 1e4 positions
set.seed(999)
x <- glSim(n.ind = 10, n.snp.nonstruc = 5e2, n.snp.struc = 5e2, ploidy = 2)
position(x) <- sort(sample(1e4, 1e3))
res <- samp.ia(x)
hist(res)

# with unstructured snps assuming 1e4 positions
set.seed(999)
x <- glSim(n.ind = 10, n.snp.nonstruc = 1e3, ploidy = 2)
position(x) <- sort(sample(1e4, 1e3))
res <- samp.ia(x)
hist(res)
}
}
\author{
Zhian N. Kamvar, Jonah C. Brooks
}

