% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_dispatch.R
\name{custom_helper}
\alias{custom_helper}
\title{Custom generator}
\usage{
custom_helper(X, Y, W, Y.hat.model, W.hat.model)
}
\arguments{
\item{X}{A matrix of covariates}

\item{Y}{A vector of the target variable, of same length as the number of rows of Y}

\item{W}{A vector of the treatment variable, of same length as the number of rows of X}

\item{Y.hat.model}{A function generates a model to predict from. (with a predict method)}

\item{W.hat.model}{A function generates a model to predict from. (with a predict method)}
}
\value{
A list with two elements: The fitted W model and the fitted Y model.
}
\description{
Generates custom methods for use in post-double selection based on user specified inputs
}
\examples{


 n = 2000; p = 10
 X = matrix(rnorm(n*p), n, p)
 W = rbinom(n, 1, 0.4 + 0.2 * (X[,1] > 0))
 Y = rbinom(n, 1,( W + 0.1 * (X[,3] > 0) ))
 Y[is.na(Y)] <- 1

Y_est <- function(X,Y){
Y_model <- glm(Y~.,family = binomial,data = as.data.frame(cbind(X,Y)))
}

W_est <- function(X,W){
W_model <- glm(W~.,family = binomial,data = as.data.frame(cbind(X,W)))
}

 custom_helper(X = X, Y = Y, W = W,
                  Y.hat.model = substitute(Y_est),
                  W.hat.model = substitute(W_est))

 custom_helper( X = X, Y = Y, W = W,
                Y.hat.model =
                             expression(
                             glm(Y~.,family = "binomial",data = as.data.frame(cbind(X,Y)))
                             ),
                W.hat.model =
                             expression(
                             glm(W~.,family = "gaussian",data = as.data.frame(cbind(X,Y)))
                             )
              )


}
