% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvar-summaries-within-draws.R
\name{rvar-summaries-within-draws}
\alias{rvar-summaries-within-draws}
\alias{rvar_mean}
\alias{rvar_median}
\alias{rvar_sum}
\alias{rvar_prod}
\alias{rvar_min}
\alias{rvar_max}
\alias{rvar_sd}
\alias{rvar_var}
\alias{rvar_mad}
\alias{rvar_range}
\alias{rvar_quantile}
\alias{rvar_all}
\alias{rvar_any}
\title{Summaries of random variables over array elements, within draws}
\usage{
rvar_mean(..., na.rm = FALSE)

rvar_median(..., na.rm = FALSE)

rvar_sum(..., na.rm = FALSE)

rvar_prod(..., na.rm = FALSE)

rvar_min(..., na.rm = FALSE)

rvar_max(..., na.rm = FALSE)

rvar_sd(..., na.rm = FALSE)

rvar_var(..., na.rm = FALSE)

rvar_mad(..., constant = 1.4826, na.rm = FALSE, low = FALSE, high = FALSE)

rvar_range(..., na.rm = FALSE)

rvar_quantile(..., probs, names = FALSE, na.rm = FALSE)

rvar_all(..., na.rm = FALSE)

rvar_any(..., na.rm = FALSE)
}
\arguments{
\item{...}{(rvar) One or more \code{\link{rvar}}s.}

\item{na.rm}{(logical) Should \code{NA}s be removed from the input before
summaries are computed? The default is \code{FALSE}.}

\item{constant}{(scalar real) For \code{rvar_mad()}, a scale factor for computing
the median absolute deviation. See the details of \code{stats::mad()} for the
justification for the default value.}

\item{low}{(logical) For \code{rvar_mad()}, if \code{TRUE}, compute the 'lo-median',
i.e., for even sample size, do not average the two middle values, but take
the smaller one. See \code{stats::mad()}.}

\item{high}{(logical) For \code{rvar_mad()}, if \code{TRUE}, compute the 'hi-median',
i.e., take the larger of the two middle values for even sample size. See
\code{stats::mad()}.}

\item{probs}{(numeric vector) For \code{rvar_quantile()}, probabilities in \verb{[0, 1]}.}

\item{names}{(logical) For \code{rvar_quantile()}, if \code{TRUE}, the result has a
\code{names} attribute.}
}
\value{
An \code{\link{rvar}} of length 1 (for \code{range()}, length 2; for \code{quantile()}, length
equal to \code{length(probs)}) with the same number
of draws as the input rvar(s) containing the summary statistic computed within
each draw of the input rvar(s).
}
\description{
Compute summaries of random variables over array elements and within draws,
producing a new random variable of length 1 (except in the case of
\code{rvar_range()}, see \strong{Details}).
}
\details{
These functions compute statistics within each draw of the random variable.
For summaries over draws (such as expectations), see \link{rvar-summaries-over-draws}.

Each function defined here corresponds to the base function of the same name
without the \code{rvar_} prefix (e.g., \code{rvar_mean()} calls \code{mean()} under the hood, etc).
}
\examples{

set.seed(5678)
x = rvar_rng(rnorm, 4, mean = 1:4, sd = 2)

# These will give similar results to mean(1:4),
# median(1:4), sum(1:4), prod(1:4), etc
rvar_mean(x)
rvar_median(x)
rvar_sum(x)
rvar_prod(x)
rvar_range(x)
rvar_quantile(x, probs = c(0.25, 0.5, 0.75), names = TRUE)

}
\seealso{
\link{rvar-summaries-over-draws} for summary functions across draws (e.g. expectations).
\link{rvar-dist} for density, CDF, and quantile functions of random variables.

Other rvar-summaries: 
\code{\link{rvar-summaries-over-draws}},
\code{\link{rvar_is_finite}()}
}
\concept{rvar-summaries}
