% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample_draws.R
\name{resample_draws}
\alias{resample_draws}
\alias{resample_draws.draws}
\title{Resample \code{draws} objects}
\usage{
resample_draws(x, ...)

\method{resample_draws}{draws}(x, weights = NULL, method = "stratified", ndraws = NULL, ...)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{...}{Arguments passed to individual methods (if applicable).}

\item{weights}{(numeric vector) A vector of positive weights of length
\code{ndraws(x)}. The weights will be internally normalized. If \code{weights} is not
specified, an attempt will be made to extract any weights already stored in
the draws object (via \code{\link[=weight_draws]{weight_draws()}}). How exactly the weights influence
the resampling depends on the \code{method} argument.}

\item{method}{(string) The resampling method to use:
\itemize{
\item \code{"simple"}: simple random resampling with replacement
\item \code{"simple_no_replace"}: simple random resampling without replacement
\item \code{"stratified"}: stratified resampling with replacement
\item \code{"deterministic"}: deterministic resampling with replacement
}

Currently, \code{"stratified"} is the default as it has comparably low variance
and bias with respect to ideal resampling. The latter would sample perfectly
proportional to the weights, but this is not possible in practice due to the
finite number of draws available. For more details about resampling methods,
see Kitagawa (1996).}

\item{ndraws}{(positive integer) The number of draws to be returned. By
default \code{ndraws} is set internally to the total number of draws in \code{x} if
sensible.}
}
\value{
A \code{draws} object of the same class as \code{x}.
}
\description{
Resample \code{\link{draws}} objects according to provided weights, for example weights
obtained through importance sampling.
}
\details{
Upon usage of \code{resample_draws()}, chains will automatically be merged
due to subsetting of individual draws (see \code{\link{subset_draws}} for details).
Also, weights stored in the \code{draws} object will be removed in the process,
as resampling invalidates existing weights.
}
\examples{
x <- as_draws_df(example_draws())

# random weights for justr for demonstration
w <- runif(ndraws(x), 0, 10)

# use default stratified sampling
x_rs <- resample_draws(x, weights = w)
summarise_draws(x_rs, default_summary_measures())

# use simple random sampling
x_rs <- resample_draws(x, weights = w, method = "simple")
summarise_draws(x_rs, default_summary_measures())

}
\references{
Kitagawa, G., Monte Carlo Filter and Smoother for Non-Gaussian Nonlinear '
State Space Models, \emph{Journal of Computational and Graphical Statistics},
5(1):1-25, 1996.
}
\seealso{
\code{\link[=resample_draws]{resample_draws()}}
}
