% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvar-summaries-within-draws.R
\name{rvar_is_finite}
\alias{rvar_is_finite}
\alias{rvar_is_infinite}
\alias{rvar_is_nan}
\alias{rvar_is_na}
\title{Special value predicates for random variables}
\usage{
rvar_is_finite(x)

rvar_is_infinite(x)

rvar_is_nan(x)

rvar_is_na(x)
}
\arguments{
\item{x}{(rvar) An \code{\link{rvar}}.}
}
\value{
A logical \code{\link{rvar}} of the same length as the input.
}
\description{
Compute special value predicates (checking for finite / infinite values, \code{NaN}, and \code{NA})
on all draws within a random variable, returning a random variable.
}
\details{
These functions return a new \code{\link{rvar}} that is the result of applying
\code{is.finite()}, \code{is.infinite()}, \code{is.nan()}, or \code{is.na()} to every draw
in the input random variable.
}
\examples{

x <- rvar(c(1, Inf, -Inf, NaN, NA))
x

rvar_is_finite(x)
rvar_is_infinite(x)
rvar_is_nan(x)
rvar_is_na(x)

}
\seealso{
\link{rvar-summaries-over-draws} for summary functions across draws, including
implementations of \code{is.finite()}, \code{is.infinite()}, \code{is.nan()}, and \code{is.na()} for
\code{rvar}s.

Other rvar-summaries: 
\code{\link{rvar-summaries-over-draws}},
\code{\link{rvar-summaries-within-draws}}
}
\concept{rvar-summaries}
