% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepost_estimation_helpers.R
\name{ebp_report_byrank}
\alias{ebp_report_byrank}
\title{Produce EBP Head Count Population/Rate by Rank}
\usage{
ebp_report_byrank(
  model,
  pop_data,
  pop_domains,
  pop_weights = NULL,
  byrank_indicator = "count",
  number_to_list = NULL,
  head = TRUE,
  indicator = "Head_Count"
)
}
\arguments{
\item{model}{an object returned by the ebp function of type "emdi ebp".}

\item{pop_data}{the population/census/training data}

\item{pop_domains}{a character string containing the name of a variable that
indicates domains in the population data. The variable can be numeric or a
factor but needs to be of the same class as the variable named in
\code{smp_domains}.}

\item{pop_weights}{a character string containing the name of a variable that
indicates population weights in the populatation data. If a character string
is provided weighted indicators are estimated using population weights.
The variable has to be numeric. Defaults to \code{NULL}. Please note that
\code{pop_weights} should only be used if in the \code{pop_data} not
individual data is provided and thus the number of persons per unit (e.g.
household, grid) must be indicated.}

\item{byrank_indicator}{if argument is "count", the function ranks the
product of Head_Count (from object of class `ebp`) and `pop_weights`,
otherwise it the function simply ranks Head_Count output within `ebp` object}

\item{number_to_list}{an integer, the first `number_to_list` number of
target areas to produce from `byrank_indicator` ordering.}

\item{head}{a logical, if `TRUE` the top `number_to_list` results will be
returned and if `FALSE` the bottom `number_to_list` will be returned}

\item{indicator}{a character string containing the name of the indicator to rank.
Defaults to "Head_Count"}
}
\value{
dataframe containing population size, head count values and counts of
poor population
}
\description{
This function combines the ebp object with the census data to produce report
tables that rank head count estimates either by population of poor or the
head count rates themselves in descending order. The function allows the user
to select the first/last "x" number of areas by name as well.
}
\examples{
data("eusilcA_pop")
data("eusilcA_smp")

ebp_model <- ebp(
 fixed = eqIncome ~ gender + eqsize + cash + self_empl +
    unempl_ben + age_ben + surv_ben + sick_ben + dis_ben + rent + fam_allow +
    house_allow + cap_inv + tax_adj,
 pop_data = eusilcA_pop, pop_domains = "district",
 smp_data = eusilcA_smp, smp_domains = "district", L = 2,
 weights = "weight", weights_type = "nlme", na.rm = TRUE,
 pop_weights = "hhsize")

# full data of highest population below threshold by rank (descending order)
ebp_report_byrank(model = ebp_model,
                  pop_data = eusilcA_pop,
                  pop_domains = "district",
                  pop_weights = "hhsize")

# full data of highest rate below threshold by rank (descending order)
ebp_report_byrank(model = ebp_model,
                  pop_data = eusilcA_pop,
                  pop_domains = "district",
                  pop_weights = "hhsize",
                  byrank_indicator = "rate")

# bottom 10 poverty count below threshold by rank (in ascending order)
ebp_report_byrank(model = ebp_model,
                  pop_data = eusilcA_pop,
                  pop_domains = "district",
                  pop_weights = "hhsize",
                  number_to_list = 10,
                  head = FALSE)

}
