% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{summary.plcp_sim}
\alias{summary.plcp_sim}
\title{Summarize the results from a simulation of a single study design-object}
\usage{
\method{summary}{plcp_sim}(object, alpha = 0.05, ...)
}
\arguments{
\item{object}{A \code{simulate.plcp}-object}

\item{alpha}{Indicates the significance level. Default is 0.05 (two-tailed),
one-tailed tests are not yet implemented.}

\item{...}{Currently not used}
}
\value{
Object with class \code{plcp_sim_summary}. It contains
the following output:
\itemize{
 \item \code{parameter} is the name of the coefficient
 \item \code{M_est} is the mean of the estimates taken over all the simulations.
 \item \code{M_se} is the mean estimated standard error taken over all the simulations.
 \item \code{SD_est} is the empirical standard error; i.e. the standard
 deviation of the distribution of the generated estimates.
 \item \code{power} is the empirical power of the Wald Z test, i.e. the proportion
 of simulated p-values < alpha.
 \item \code{power_satt} is the empirical power of the Wald \emph{t} test using
  Satterthwaite's degree of freedom approximation.
 \item \code{satt_NA} is the proportion of Satterthwaite's approximations that failed.
 \item \code{prop_zero} is the proportion of the simulated estimates that
 are zero; only shown for random effects.
}
}
\description{
Summarize the results from a simulation of a single study design-object
}
