% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiMWI2015_pbm}
\alias{ppiMWI2015_pbm}
\title{ppiMWI2015_pbm}
\format{A data frame with 13 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nlFood}}{Food poverty line}
\item{\code{nl100}}{National poverty line (100\%)}
\item{\code{nl150}}{National poverty line (150\%)}
\item{\code{nl200}}{National poverty line (200\%)}
\item{\code{half100}}{Poorest half below 100\% national}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp200}}{Below $2.00 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
\item{\code{ppp500}}{Below $5.00 per day purchasing power parity (2005)}
\item{\code{ppp844}}{Below $8.44 per day purchasing power parity (2005)}
\item{\code{ppp190}}{Below $1.90 per day purchasing power parity (2011)}
\item{\code{ppp310}}{Below $3.10 per day purchasing power parity (2011)}
}}
\source{
\url{www.povertyindex.org}
}
\usage{
ppiMWI2015_pbm
}
\description{
Poverty Probability Index (PPI) lookup table for Malawi using PBM poverty
definitions
}
\examples{
  # Access Malawi PPI table
  ppiMWI2015_pbm

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiMWI2015_pbm[ppiMWI2015_pbm$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiMWI2015_pbm, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # poverty line definition
  ppiScore <- 50
  ppiMWI2015_pbm[ppiMWI2015_pbm$score == ppiScore, "nl100"]

}
\keyword{datasets}
