\name{cluspop.nb}
\alias{cluspop.nb}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Simulation of presence-absence matrices (clustered)}
\description{
  Generates a simulated matrix where the rows are interpreted as regions
  and the columns as species, 1 means that a species is present in the
  region and 0 means that the species is absent. Species are generated
  in order to produce 2 clusters of species with similar ranges.
  Spatial autocorrelation of a species' presences is governed by
  the parameter \code{p.nb} and a list of neighbors for each region.
}
\usage{
cluspop.nb(neighbors, p.nb = 0.5, n.species, clus.specs, reg.group,
grouppf = 10, n.regions = length(neighbors),
vector.species = rep(1, n.species), pdf.regions = rep(1/n.regions,
n.regions), count = TRUE, pdfnb = FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{neighbors}{A list with a component for every region. The
    components are vectors of integers indicating
    neighboring regions. A region without neighbors (e.g., an island)
    should be assigned a list \code{numeric(0)}.}
  \item{p.nb}{numerical between 0 and 1. The probability that a new
    region is drawn from the non-neighborhood of the previous regions
    belonging to a species under generation. Note that for a given
    presence-absence matrix, this parameter can be estimated by
    \code{autoconst} (called \code{pd} there).}
  \item{n.species}{integer. Number of species.}
  \item{clus.specs}{integer not larger than \code{n.species}. Number of
    species restricted to one of the two groups of regions defined by
    \code{reg.group} (called "clustered species" because this leads to
    more similar species ranges).}
  \item{reg.group}{vector of pairwise distinct integers not larger than
    \code{n. regions}. Defines a group of regions to which a part of the
    \code{clus.specs} clustered species is restricted (more or less, see
    \code{grouppf}). The other clustered species are restricted to the
    complementary regions.}
  \item{grouppf}{numerical. The probability of the region of
    a clustered species to belong to the corresponding group of regions
    is up-weighted by factor \code{grouppf} compared to the generation
    of "non-clustered" species.}
  \item{n.regions}{integer. Number of regions.}
  \item{vector.species}{vector of integers. The sizes
    (i.e., numbers of regions)
    of the species are generated randomly from
    the empirical distribution of \code{vector.species}.}
  \item{pdf.regions}{numerical vector of length \code{n.species}. The
    entries must sum up to 1 and give probabilities for the regions to
    be drawn during the generation of a species. These probabilities are
    used conditional on the new region being a neighbor or a
    non-neighbor of the previous regions of the species, see
    \code{p.nb}, modified by \code{grouppf} for the clustered species.}
  \item{count}{logical. If \code{TRUE}, the number of the currently
    generated species is printed.}
  \item{pdfnb}{logical. If \code{TRUE}, the probabilities of the regions
    are modified according to the number of neighboring regions by
    dividing them relative to the others by min(1,number of neighbors).}
}
\details{
  The non-clustered species are generated as explained on the help page
  for \code{randpop.nb}. The general principle for the clustered species
  is the same, but with modified probabilities for the regions. For each
  clustered species, one of the two groups of regions is drawn,
  distributed according to the sum of its regions' probability given by
  \code{pdf.regions}. The first region of such a species is only drawn
  from the regions of this group.
}
\value{
  A 0-1-matrix, rows are regions, columns are species.
}
\references{
Hennig, C. and Hausdorf, B. (2004) Distance-based parametric bootstrap
tests for clustering of species ranges. \emph{Computational Statistics
  and
  Data Analysis} 45, 875-896.
}

\author{Christian Hennig
  \email{chrish@stats.ucl.ac.uk}
  \url{http://www.homepages.ucl.ac.uk/~ucakche}}

\seealso{
  \code{\link{randpop.nb}},
  
  \code{\link{autoconst}} estimates \code{p.nb} from matrices of class
  \code{prab}. These are generated by \code{\link{prabinit}}.
}

\examples{
data(nb)
# Note: If you do not use the installed package, replace this by
# nb <- list()
# for (i in 1:34)
#   nb <- c(nb,list(scan(file="(path/)nb.dat",
#                   skip=i-1,nlines=1)))
set.seed(888)
cluspop.nb(nb, p.nb=0.1, n.species=10, clus.specs=9, reg.group=1:17,
vector.species=c(10))
}
\keyword{spatial}% at least one, from doc/KEYWORDS
