% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pplot.deciles.r
\name{pplot.deciles}
\alias{pplot.deciles}
\alias{precintcon.plot.deciles}
\title{Plot deciles}
\usage{
pplot.deciles(\dots, grouped = FALSE, ylab = "Precipitation",
legend.title = "Legend", legend = NULL,
fontsize = 10, axis.text.color = "black",
export = FALSE, export.name = "deciles_plot.png",
width = 8.6, height = 7.5, units = "cm")
}
\arguments{
\item{grouped}{a logical value that defines whether all datasets should be
plotted in the same graph or not. (Default value: FALSE)}

\item{ylab}{the text for the y axis. (Default value: "Precipitation")}

\item{legend.title}{the text for the legend title. (Default value: "Legend")}

\item{legend}{the text vector for the legend items. If NULL the legends will
be equals to the variable names. (Default value: NULL)}

\item{fontsize}{the font size value in pt. (Default value: 10)}

\item{axis.text.color}{the legend colors. (Default value: "black")}

\item{export}{the logical value for defining whether the graph should be
export to a file or not. (Default value: FALSE)}

\item{export.name}{the text for defining the exported file name. It is only
used if export = TRUE. (Default value: "deciles_plot.png")}

\item{width}{the number for defining the exported graph width. It is only used
if export = TRUE. (Default value: 8.6)}

\item{height}{the number for defining the exported graph height. It is only
used if export = TRUE. (Default value: 7.5)}

\item{units}{the text for defining the units of the height and width
parameters. It is only used if export = TRUE. (Default value: "cm")}

\item{\dots}{a set of daily or monthly precipitation serie.}
}
\description{
Plots the deciles of a precipitation serie.
}
\examples{
## Loading the monthly precipitation serie.
#
data(monthly)

## Performing the a set of statistical analysis
#
pplot.deciles(monthly)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{deciles}}
\code{\link{read.data}}
}
\keyword{deciles}
\keyword{precipitation}

