% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pi_rho_est.R
\name{pi_rho_est}
\alias{pi_rho_est}
\title{Estimation of the binomial proportion and the intra class correlation.}
\usage{
pi_rho_est(dat)
}
\arguments{
\item{dat}{a \code{data.frame} with two columns (successes and failures)}
}
\value{
a vector containing estimates for \eqn{\pi} and \eqn{\rho}
}
\description{
pi_rho_est estimates the overall binomial proportion \eqn{\hat{\pi}} and the intra
class correlation \eqn{\hat{\rho}} of data that is assumed to follow the beta-binomial
distribution. The estimation of \eqn{\hat{\pi}} and \eqn{\hat{\rho}} is done following
the approach of Lui et al. 2000.
}
\examples{
# Estimates for bb_dat1
pi_rho_est(bb_dat1)

}
\references{
Lui, K.-J., Mayer, J.A. and Eckhardt, L: Confidence intervals for the risk ratio
under cluster sampling based on the beta-binomial model. Statistics in Medicine.2000;19:2933-2942.
\doi{10.1002/1097-0258(20001115)19:21<2933::AID-SIM591>3.0.CO;2-Q}
}
