% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tas_data.R
\docType{data}
\name{tas_data}
\alias{tas_data}
\alias{tas_features}
\alias{tas_pu}
\title{Tasmania data}
\format{
\describe{
\item{tas_features}{\code{\linkS4class{RasterStack}} object}
\item{tas_pu}{\code{\link[sp:SpatialPolygons]{sp::SpatialPolygonsDataFrame()}} object.}
}
}
\usage{
data(tas_features)

data(tas_pu)
}
\description{
This dataset was obtained from the
\href{https://marxansolutions.org/}{"Introduction to \emph{Marxan}" course}
and was originally part of a larger spatial prioritization performed under
contract to Australia's Department of Environment and Water Resources
(Klein \emph{et al.} 2007). For a worked example with this
dataset, refer to the \href{https://CRAN.R-project.org/package=prioritizr/vignettes/tasmania.html}{Tasmania vignette in the \pkg{prioritizr} package}.
}
\details{
The dataset contains the following items:

\describe{

\item{\code{tas_pu}}{Planning unit data. The attribute table has
three columns containing unique identifiers (\code{"id"}),
unimproved land values (\code{"cost"}), and their existing level of
protection (\code{"status"}). Units with 50\% or more of their area
contained in protected areas are associated with a status of 2,
otherwise they are associated with a value of 0.
It also contains columns (\code{"locked_in"} and \code{"locked_out"})
with \code{logical} values (i.e. \code{TRUE} or \code{FALSE} values)
for locking in and locking out planning units.}

\item{\code{tas_features}}{The distribution of 62 vegetation
classes in Tasmania, Australia. Each layer in the stack
represents a different vegetation class. For a given layer,
cells indicate the presence (value of 1) or absence (value of 0)
of the vegetation class in an area.}
}
}
\examples{
# load data
data(tas_pu, tas_features)

# preview data
print(tas_pu)
print(tas_features)

# plot data
plot(tas_pu)
plot(tas_features)

}
\references{
Klein C, Carwardine J, Wilson K, Watts M, and Possingham H (2007) \emph{Spatial
Prioritization Approaches for the Conservation of Biodiversity in
Australia: Considering Conservation Costs, Ecological & Evolutionary
Processes, and Large-Intact Areas.} Report to the Department of
Environment; Water Resources.
}
\keyword{datasets}
