% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prism_archive_verify.R
\name{prism_archive_verify}
\alias{prism_archive_verify}
\alias{check_corrupt}
\title{Check the integrity of downloaded PRISM data}
\usage{
prism_archive_verify(
  type,
  temp_period,
  years = NULL,
  mon = NULL,
  minDate = NULL,
  maxDate = NULL,
  dates = NULL,
  download_corrupt = TRUE,
  keepZip = TRUE
)

check_corrupt(type, minDate = NULL, maxDate = NULL, dates = NULL)
}
\arguments{
\item{type}{The type of data you want to subset. Must be "ppt", "tmean",
"tmin", "tmax", "tdmean", "vpdmin", "vpdmax", "solclear", "solslope",
"soltotal", or "soltrans".}

\item{temp_period}{The temporal period to subset. Must be "annual",
"monthly", "daily", "monthly normals", or "annual normals".}

\item{years}{Valid numeric year, or vector of years.}

\item{mon}{Valid numeric month, or vector of months.}

\item{minDate}{Date to start subsetting daily data. Must be specified in
a valid iso-8601 (e.g. YYYY-MM-DD) format. May be provided as either a
character or \link[base:Dates]{base::Date} class.}

\item{maxDate}{Date to end subsetting daily data.  Must be specified in
a valid iso-8601 (e.g. YYYY-MM-DD) format. May be provided as either a
character or \link[base:Dates]{base::Date} class.}

\item{dates}{A vector of daily dates to subset. Must be specified in
a valid iso-8601 (e.g. YYYY-MM-DD) format. May be provided as either a
character or \link[base:Dates]{base::Date} class.}

\item{download_corrupt}{If \code{TRUE}, then any unreadable prism data are
automatically re-downloaded.}

\item{keepZip}{If \code{TRUE}, leave the downloaded zip files in your
'prism.path', if \code{FALSE}, they will be deleted.}
}
\value{
\code{prism_archive_verify()} returns \code{TRUE} if all data are readable.
Any prism data that are not readable are returned (folder names), whether
they are re-downloaded or not.

\code{check_corrupt()} returns \code{logical} indicating whether the process
succeeded.
}
\description{
\code{prism_archive_verify()} checks the data in the prism archive to ensure it
is valid, or at least can be read into R, i.e., it is not corrupt. The
prism variable type, time period, etc. is specified the same as for
\code{\link[=prism_archive_subset]{prism_archive_subset()}}. Any files that are not readable can automatically
be re-downloaded.

\code{check_corrupt()} is the deprecated version of
\code{prism_archive_verify()}
}
\details{
Under the hood, it uses \code{raster::stack()} and then \code{raster::rasterToPoints()}
to determine if the bil files are readable. If both those files are able
to successfully read the files, they are assumed to be valid/readable.
}
\examples{
\dontrun{
# check all annual precipitation data from 2000-2023 are readable
# x will contain any corrupt files, or be TRUE if they are all readable
x <- prism_archive_verify('ppt', 'annual', 2000:2023)
}

  
}
