% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/pickapoint.R
\name{pickapoint}
\alias{pickapoint}
\alias{spotlight}
\title{Pick-A-Point Technique}
\usage{
pickapoint(model, dv, iv, mod, points, method = "meansd", alpha = 0.05,
  yas = "none")
}
\arguments{
\item{model}{Regression model (lm, glm, list).}

\item{dv}{Dependent variable (character).}

\item{iv}{Independent variable (character).}

\item{mod}{Moderator variable(s) (character or character vector).}

\item{points}{List of points to test for each moderator variable (list).}

\item{method}{Method to use. Possible values are: \code{"meansd", "percentiles"}, \code{method="meansd"} by default.}

\item{alpha}{Alpha level to use (numeric).}

\item{yas}{Show y (or conditional effect) as: \code{"none", "ratio","probability","percentage"}, \code{yas="none"} by default.}
}
\value{
A list with the elements
}
\description{
Probe moderation effect using the Pick-A-Point technique
}
\examples{
\dontrun{
myModel <- lm('dv ~ iv + mod', data=someData)
pickapoint(myModel, dv='DV', iv='IV', mod='MOD')
pickapoint(myModel, dv='DV', iv='IV', mod='MOD', alpha=.01)
pickapoint(myModel, dv='DV', iv='IV', mod='MOD', method='percentiles')
pickapoint(myModel, dv='DV', iv='IV', mod='MOD', points=c(1,2,3))
}
}
\references{
Spiller, S. A., Fitzsimons, G. J., Lynch, J. G., Jr, & McClelland, G. H. (2013). Spotlights, floodlights, and the magic number zero: Simple effects tests in moderated regression. Journal of Marketing Research, 50(2), 277-288.

Aiken, L. S., & West, S. G. (1991). Multiple regression: Testing and interpreting interactions. Thousand Oaks, CA: Sage Publications.
}

