% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim_hmm}
\alias{sim_hmm}
\title{Simulating action sequences using HMM}
\usage{
sim_hmm(n, paras, min_len, mean_len, return_state = TRUE)
}
\arguments{
\item{n}{number of action sequences to be generated}

\item{paras}{a list containing specified HMM parameters: state-transition probability matrix (\code{P}),
state-action probability matrix (\code{Q}), and initial state probability (\code{P1}).}

\item{min_len}{minimum length of generated sequences}

\item{mean_len}{mean length of generated sequences}

\item{return_state}{logical. Whether generated hidden state sequences should be returned or not.}
}
\value{
\code{sim_hmm} returns a list of \code{n} generated action sequences if \code{return_state = FALSE}.
If \code{return_state = TRUE}, it returns a list of two lists, \code{seqs} and \code{state_seqs}. \code{seqs} gives
the generated action sequences. \code{state_seqs} gives the corresponding hidden state sequences.
}
\description{
\code{sim_hmm} generate \code{n} action sequences from HMM based on given parameters.
The lengths of the generated sequences are simulated from a Poission distribution with
mean \code{mean_len} and at least \code{min_len}.
}
\examples{
paras <- sim_hmm_paras(5,2)
sim_data <- sim_hmm(20, paras, 3, 10)

}
