% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggscales.R
\name{scale_color_profinit}
\alias{scale_color_profinit}
\alias{scale_colour_profinit}
\alias{scale_color_profinit_d}
\alias{scale_colour_profinit_d}
\alias{scale_color_profinit_c}
\alias{scale_colour_profinit_c}
\title{Profinit color scale constructor}
\usage{
scale_color_profinit(
  palette = "blue-red",
  discrete = TRUE,
  reverse = FALSE,
  exact = NULL,
  na.value = NULL,
  ...
)

scale_colour_profinit(
  palette = "blue-red",
  discrete = TRUE,
  reverse = FALSE,
  exact = NULL,
  na.value = NULL,
  ...
)

scale_color_profinit_d(palette = "blue-red", ...)

scale_colour_profinit_d(palette = "blue-red", ...)

scale_color_profinit_c(palette = "blue-red", ...)

scale_colour_profinit_c(palette = "blue-red", ...)
}
\arguments{
\item{palette}{Character name of palette in \code{profinit_palettes}. Use \code{profinit_pal.pals()} to list available palettes.}

\item{discrete}{Boolean indicating whether color aesthetic is discrete or not. Defaults to \code{TRUE}.}

\item{reverse}{Boolean indicating whether the palette should be reversed. Defaults to \code{FALSE}.}

\item{exact}{Indicates whether the color scale is supposed to be followed exactly.
Be ware you may run out of colors. Defaults to \code{TRUE} for discrete palette names, \code{FALSE} otherwise.}

\item{na.value}{What value is going to be used for missings. Defaults to profinit's grey with some transparency added.}

\item{...}{Additional arguments passed to \code{ggplot2::discrete_scale()} or
\code{ggplot2::scale_color_gradientn()}, used respectively when \code{discrete} is set to \code{TRUE} or \code{FALSE}}
}
\value{
Ggplot2 color scale constructor based on Profinit color palette.
}
\description{
Profinit color scale constructor

\code{scale_color_profinit_d} - Discrete Profinit color scale (similar to
\code{scale_color_viridis_d}). It can't be used with continuous variables. There
is BrE equivalent, too: \code{scale_colour_profinit_d}.

\code{scale_color_profinit_c} - Continuous Profinit color scale (similar to
\code{scale_color_viridis_c}). It can't be used with discrete variables. There is
BrE equivalent, too: \code{scale_colour_profinit_c}.
}
\examples{
library(ggplot2)

iris_plt <- ggplot(iris, aes(x = Sepal.Width, y = Sepal.Length, color = Species)) +
  geom_point() +
  theme_profinit()

iris_plt + scale_color_profinit()

# Now, let's use another Profinit palette:
# (see `profinit_pal.pals()` for all the options)
iris_plt + scale_color_profinit(palette = "reds-dark")



}
\concept{scale_color_profinit}
