% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/522.Error-Failure_Limitbased_CC_All_Graph.R
\name{PloterrCSC}
\alias{PloterrCSC}
\title{Plots the error, long term power and pass/fail criteria for continuity corrected Score method}
\usage{
PloterrCSC(n, alp, phi, c, f)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{phi}{- Null hypothesis value}

\item{c}{- Continuity correction}

\item{f}{- Failure criterion}
}
\description{
Plots the error, long term power and pass/fail criteria for continuity corrected Score method
}
\details{
Plot of continuity corrected score test approach using error due to the
difference of achieved and nominal level of significance for the \eqn{n + 1} intervals
}
\examples{
n=5; alp=0.05; phi=0.05;c=1/(2*n); f=-2
PloterrCSC(n,alp,phi,c,f)
}
\seealso{
Other Error for continuity corrected methods: \code{\link{PloterrCAS}},
  \code{\link{PloterrCAll}}, \code{\link{PloterrCLT}},
  \code{\link{PloterrCTW}}, \code{\link{PloterrCWD}},
  \code{\link{errCAS}}, \code{\link{errCAll}},
  \code{\link{errCLT}}, \code{\link{errCSC}},
  \code{\link{errCTW}}, \code{\link{errCWD}}
}
