% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclust.R
\name{upper}
\alias{upper}
\title{Get the upper cut of a protoclust object}
\usage{
upper(hc, h = NULL, k = NULL)
}
\arguments{
\item{hc}{protoclust object}

\item{h}{cut height}

\item{k}{number of leaves that upper cut should have}
}
\value{
\describe{
  \item{hc}{protoclust object representing the upper cut}
  \item{i.original}{index of each element in original tree}
  \item{merge.id.leaf}{merge.id from original tree of each leaf}
  \item{merge.id.interior}{merge.id from original tree of each interior node}
  \item{h}{cut height}
  \item{n.original}{number of objects in original tree}
}
}
\description{
Gets the upper part of the tree when you cut at height h (or alternately to 
have k leaves).  Returns a valid protoclust object.  This new tree has a
different indexing from the original tree.  i.original can be used to recover
the old indexing and merge.id indicates for each leaf of new tree that had
been an interior node, the merge.id of it.
}
\keyword{internal}
