% Generated by roxygen2 (4.0.1): do not edit by hand
\name{find_uses}
\alias{find_uses}
\title{Find all functions in that call supplied functions.}
\usage{
find_uses(envs, funs, match_any = TRUE)
}
\arguments{
\item{envs}{Vector of environments to look in. Can be specified by
name, position or as environment}

\item{funs}{Functions to look for}

\item{match_any}{If \code{TRUE} return functions that use any of \code{funs}.
If \code{FALSE}, return functions that use all of \code{funs}.}
}
\description{
Find all functions in that call supplied functions.
}
\examples{
names(find_uses("package:base", "sum"))

envs <- c("package:base", "package:utils", "package:stats")
funs <- c("match.call", "sys.call")
find_uses(envs, funs)
}

