% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmsea.R
\name{rmsea}
\alias{rmsea}
\title{Root mean squared error of area}
\usage{
rmsea(observed, fitted)
}
\arguments{
\item{observed}{is the response variable of polygonal linear regression model.}

\item{fitted}{are the polygons obtained from polygonal linear regression model as fitted
values of the response variable.}
}
\value{
rmsea the value of the root mean squared error of area.
}
\description{
Root mean squared error of area is a meansure proposed by Silva et al. (2019). It
is used to evaluate the performance of symbolic polygonal linear regression model (\code{plr}).
}
\examples{
yp <- psim(10, 10) #simulate 10 polygons of 10 sides
xp1 <- psim(10, 10) #simulate 10 polygons of 10 sides
xp2 <- psim(10, 10) #simulate 10 polygons of 10 sides
e <- new.env()
e$yp <- yp
e$xp1 <- xp1
e$xp2 <- xp2
fit <- plr(yp~xp1+xp2-1, e)
yp_fitted <- fitted(fit, polygon = TRUE, vertices = 10) #Shows the polygon fitted from plr 
rmsea(yp, yp_fitted)
}
\references{
Silva, W.J.F, Souza, R.M.C.R, Cysneiros, F.J.A. (2019) \url{https://www.sciencedirect.com/science/article/pii/S0950705118304052}.
}
