% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudohouseholds.R
\name{get_phhs_single}
\alias{get_phhs_single}
\title{Get Pseudo-Households (PHH) for a single region}
\usage{
get_phhs_single(
  region,
  region_idcol,
  roads,
  region_popcol = NA,
  roads_idcol = NA,
  phh_density = 0.005,
  min_phh_pop = 5,
  min_phhs_per_region = 1,
  min_phh_distance = 25,
  road_buffer_m = 5,
  delta_distance_m = 5,
  skip_unpopulated_regions = TRUE,
  track_warnings = FALSE
)
}
\arguments{
\item{region}{simple feature object, one-row sf tibble}

\item{region_idcol}{character, name of column with unique region id}

\item{roads}{simple feature object, lines or polylines with road network}

\item{region_popcol}{character, name of column with region population}

\item{roads_idcol}{character, name of column containing road unique identifiers}

\item{phh_density}{numeric, parameter given to sf::st_line_sample()}

\item{min_phh_pop}{numeric, minimum population per phh}

\item{min_phhs_per_region}{numeric, minimum phhs per region (it will try its best)}

\item{min_phh_distance}{numeric, minimum distance between phhs in meters}

\item{road_buffer_m}{numeric, buffer in meters for intersections}

\item{delta_distance_m}{numeric, buffer in meters for intersections}

\item{skip_unpopulated_regions}{boolean, should we skip regions with no population?}

\item{track_warnings}{boolean, internal parameter used when this function is
called by get_phhs_parallel() to ensure warnings are only shown once.}
}
\value{
a simple feature object with one row per phh in the region
}
\description{
Get Pseudo-Households (PHH) for a single region
}
\examples{
phhs <- get_phhs_single(region = region_shp, region_idcol = "region_id",
region_popcol = "population", roads = road_shp, roads_idcol = "road_id")

}
