\name{cluster.fit}
\alias{cluster.fit}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ cluster Fit:  fit of the cluster model to a correlation matrix }
\description{
 How well does the cluster model found by \code{\link{ICLUST}} fit the original correlation matrix?  A similar algorithm  \code{\link{factor.fit}} is found in \code{\link{VSS}}. This function is internal to ICLUST but has more general use as well.
 
 In general, the cluster model is a Very Simple Structure model of complexity one.  That is, every item is assumed to represent only one factor/cluster. Cluster fit is an analysis of how well this model reproduces a correlation matrix.  Two measures of fit are given: cluster fit and factor fit.  Cluster fit assumes that variables that define different clusters are orthogonal.  Factor fit takes the loadings generated by a cluster model, finds the cluster loadings on all clusters, and measures the degree of fit of this somewhat more complicated model.  Because the cluster loadings are similar to, but not identical to factor loadings, the factor fits found here and by  \code{\link{factor.fit}} will be similar.   }
\usage{
cluster.fit(original, load, clusters, diagonal = FALSE, digits = 2)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{original}{The original correlation matrix being fit }
  \item{load}{ Cluster loadings -- that is, the correlation of individual items with the clusters, corrected for item overlap }
  \item{clusters}{The cluster structure }
  \item{diagonal}{ Should we fit the diagonal as well?  }
  \item{digits}{ Number of digits to be used in the output}
}
\details{The cluster model is similar to the factor model: R is fitted by C'C. Where C <- Cluster definition matrix x the loading matrix.  How well does this model approximate the original correlation matrix and how does this compare to a factor model?

The fit statistic is a comparison of the original (squared) correlations to the residual correlations.  Fit = 1 - r*2/r2 where r* is the residual correlation of data - model and model = C'C.
}
\value{
  \item{clusterfit }{The cluster model is a reduced form of the factor loading matrix.  That is, it is the product of the elements of the cluster matrix * the loading matrix. }
  \item{factorfit }{How well does the complete loading matrix reproduce the correlation matrix?}

}
\references{ \url{http://personality-project.org/r/r.ICLUST.html} }
\author{

Maintainer: William Revelle \email{revelle@northwestern.edu}

}

\seealso{  \code{\link{VSS}},  \code{\link{ICLUST}},  \code{\link{factor2cluster}},  \code{\link{cluster.cor}},  \code{\link{factor.fit}}}
\examples{
 r.mat<- Harman74.cor$cov
 iq.clus <- ICLUST(r.mat,nclusters =2)
 fit <- cluster.fit(r.mat,iq.clus$loadings,iq.clus$clusters)
 fit
 

}
\keyword{ multivariate }% at least one, from doc/KEYWORDS
\keyword{ cluster }% __ONLY ONE__ keyword per line
