% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mixture.R
\name{mix_dist}
\alias{mix_dist}
\title{Descriptive statistics for a mixture distribution}
\usage{
mix_dist(mean_vec, var_vec, n_vec, unbiased = TRUE)
}
\arguments{
\item{mean_vec}{Vector of sample means.}

\item{var_vec}{Vector of sample variances.}

\item{n_vec}{Vector of sample sizes.}

\item{unbiased}{Logical scalar determining whether variance should be unbiased (TRUE) or maximum-likelihood (FALSE).}
}
\value{
The mean, pooled sample (within-sample) variance, variance of sample means (between-groups), and mixture (total sample) variance of the mixture sample data.
}
\description{
Compute descriptive statistics for a mixture distribution. This function returns the grand mean, the pooled sample (within-sample) variance, variance of sample means (between-groups), and mixture (total sample) variance of the mixture sample data.
}
\details{
The grand mean of a mixture distribution is computed as:

\deqn{\mu=\frac{\Sigma_{i=1}^{k}\bar{x}_{i}n_{i}}{\Sigma_{i=1}^{k}n_{i}}}{mu = sum(mean_vec * n_vec) / sum(n_vec)}

where \eqn{\mu}{mu} is the grand mean, \eqn{\bar{x}_{i}}{mean_vec} represents the sample means, and \eqn{n_{i}}{n_vec} represents the sample sizes.


Maximum-likelihood mixture variances are computed as:

\deqn{var_{BG_{ML}}=\frac{\Sigma_{i=1}^{k}\left(\bar{x}_{i}-\mu\right)n_{i}}{\Sigma_{i=1}^{k}n_{i}}}{var_wg_ml = sum(var_vec * n_vec) / sum(n_vec)}
\deqn{var_{WG_{ML}}=\frac{\Sigma_{i=1}^{k}v_{i}n_{i}}{\Sigma_{i=1}^{k}n_{i}}}{var_bg_ml = sum((mean_vec - mean_mixture)^2 * n_vec) / sum(n_vec)}
\deqn{var_{mix_{ML}}=var_{BG_{ML}}+var_{WG_{ML}}}{var_mix_ml = var_bg_ml + var_wg_ml}

where \eqn{v_{i}}{var_vec} represents the sample variances.

Unbiased mixture variances are computed as:

\deqn{var_{BG_{Unbiased}}=\frac{\Sigma_{i=1}^{k}\left(\bar{x}_{i}-\mu\right)n_{i}}{\left(\Sigma_{i=1}^{k}n_{i}\right)-1}}{var_bg_unbiased = sum((mean_vec - mean_mixture)^2 * n_vec) / (sum(n_vec) - 1)}
\deqn{var_{WG_{Unbiased}}=\frac{\Sigma_{i=1}^{k}v_{i}\left(n_{i}-1\right)}{\left(\Sigma_{i=1}^{k}n_{i}\right)-1}}{var_wg_unbiased = sum(var_vec * (n_vec - 1)) / (sum(n_vec) - 1)}
\deqn{var_{mix_{Unbiased}}=var_{BG_{Unbiased}}+var_{WG_{Unbiased}}}{var_mix_unbiased = var_bg_unbiased + var_wg_unbiased}
}
\examples{
mix_dist(mean_vec = c(-.5, 0, .5), var_vec = c(.9, 1, 1.1), n_vec = c(100, 100, 100))
}
\keyword{univar}
