% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_alpha}
\alias{simulate_alpha}
\title{Generate a vector of simulated sample alpha coefficients}
\usage{
simulate_alpha(item_mat = NULL, alpha = NULL, k_items = NULL, n_cases,
  k_samples, standarized = FALSE)
}
\arguments{
\item{item_mat}{Item intercorrelation/intercovariance matrix. If item_mat is not supplied, the user must supply both \code{alpha} and \code{k_items}.
If item_mat is \code{NULL}, the program will assume that all item intercorrelations are equal.}

\item{alpha}{Population alpha value. Must be supplied if \code{item_mat} is \code{NULL}.}

\item{k_items}{Number of items on the test to be simulated. Must be supplied if \code{item_mat} is \code{NULL.}}

\item{n_cases}{Number of cases to simulate in sampling distribution of alpha.}

\item{k_samples}{Number of samples to simulate.}

\item{standarized}{Should alpha be computed from correlation matrices (\code{TRUE}) or unstandardized covariance matrices (\code{FALSE})?}
}
\value{
A vector of simulated sample alpha coefficients
}
\description{
This function generates inter-item covariance matrices from a population matrix and computes a coefficient alpha reliability estimate for each matrix.
}
\examples{
## Define a hypothetical matrix:
item_mat <- reshape_vec2mat(cov = .3, order = 12)

## Simulations of unstandardized alphas
set.seed(100)
simulate_alpha(item_mat = item_mat, n_cases = 50, k_samples = 10, standarized = FALSE)
set.seed(100)
simulate_alpha(alpha = mean(item_mat[lower.tri(item_mat)]) / mean(item_mat),
k_items = ncol(item_mat), n_cases = 50, k_samples = 10, standarized = FALSE)

## Simulations of standardized alphas
set.seed(100)
simulate_alpha(item_mat = item_mat, n_cases = 50, k_samples = 10, standarized = TRUE)
set.seed(100)
simulate_alpha(alpha = mean(item_mat[lower.tri(item_mat)]) / mean(item_mat),
k_items = ncol(item_mat), n_cases = 50, k_samples = 10, standarized = TRUE)
}
\keyword{distribution}
