% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals.R
\name{credibility}
\alias{credibility}
\title{Construct a credibility interval}
\usage{
credibility(mean, sd, k = NULL, cred_level = 0.8, cred_method = c("t",
  "norm"))
}
\arguments{
\item{mean}{Mean effect size.}

\item{sd}{Residual/true standard deviation of effect sizes, after accounting for variance from artifacts.}

\item{k}{Number of studies in the meta-analysis.}

\item{cred_level}{Credibility level that defines the width of the credibility interval (default = .80).}

\item{cred_method}{Distribution to be used to compute the width of credibility intervals. Available options are "t" for \emph{t} distribution or "norm" for normal distribution.}
}
\value{
A matrix of credibility intervals of the specified width.
}
\description{
Function to construct a credibility interval around a mean effect size.
}
\details{
\deqn{CV=mean_{es}\pm quantile\times SD_{es}}{CV = mean_es +/- quantile * SD_es}
}
\examples{
credibility(mean = .3, sd = .15, cred_level = .8)
credibility(mean = .3, sd = .15, cred_level = .8, k = 10)
credibility(mean = c(.3, .5), sd = c(.15, .2), cred_level = .8, k = 10)
}
