% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_print.R
\name{print}
\alias{print}
\title{Print methods for \strong{\code{psychmeta}}}
\arguments{
\item{x}{Object to be printed (object is used to select a method).}

\item{...}{Additional arguments.}

\item{digits}{Number of digits to which results should be rounded.}

\item{ma_methods}{Meta-analytic methods to be included. Valid options are: "bb", "ic", and "ad"}

\item{correction_types}{Types of meta-analytic corrections to be included Valid options are: "ts", "vgx", and "vgy"}

\item{verbose}{Logical scalar that determines whether printed object should contain verbose information (e.g., non-standard columns of meta-analytic output; \code{TRUE}) or not (\code{FALSE}).}

\item{n}{For \code{print.ma_psychmeta()} and \code{print.ad_tibble()}, number of rows to print for tibble. Defaults to all rows. See \code{\link[tibble:print.tbl]{tibble::print.tbl()}} for details.}

\item{width}{For \code{print.ma_psychmeta()} and \code{print.ad_tibble()}, width of text output to generate for tibble. See \code{\link[tibble:print.tbl]{tibble::print.tbl()}} for details.}

\item{n_extra}{For \code{print.ma_psychmeta()} and \code{print.ad_tibble()}, number of extra columns to print abbreviated information for, if the width is too small for the entire meta-analysis tibble. See \code{\link[tibble:print.tbl]{tibble::print.tbl()}} for details.}

\item{symbolic.cor}{For \code{print.lm_mat()}, Logical. If \code{TRUE}, print the correlations in a symbolic form (see \code{\link[stats:symnum]{stats::symnum()}}) rather than as numbers.}

\item{signif.stars}{For \code{print.lm_mat()}, Logical. If \code{TRUE}, ‘significance stars’ are printed for each coefficient.}
}
\description{
Print methods for \strong{\code{psychmeta}} output objects with classes exported from \strong{\code{psychmeta}}.
}
