% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_error.R
\name{var_error_alpha}
\alias{var_error_alpha}
\title{Analytic estimate of the sampling variance of coefficient \eqn{\alpha}}
\usage{
var_error_alpha(item_mat = NULL, alpha = NULL, k_items = NULL, n_cases)
}
\arguments{
\item{item_mat}{Item correlation/covariance matrix. If item_mat is not supplied, the user must supply both alpha and k_items.
If item_mat is NULL, the program will assume that all item intercorrelations are equal.}

\item{alpha}{Vector of population \eqn{\alpha} values. Must be supplied if item_mat is NULL.}

\item{k_items}{Vector of numbers of items to be simulated. Must be supplied if item_mat is NULL.}

\item{n_cases}{Vector of sample sizes to simulate in sampling distribution of alpha.}
}
\value{
Vector of sampling variances of the supplied \eqn{\alpha} values.
}
\description{
Estimates the error variance of Cronbach's coefficient \eqn{\alpha}.
}
\examples{
item_mat <- matrix(.3, 5, 5)
diag(item_mat) <- 1
alpha <- mean(item_mat[lower.tri(item_mat)]) / mean(item_mat)
k_items <- nrow(item_mat)

var_error_alpha(item_mat = item_mat, n_cases = 50)
var_error_alpha(alpha = alpha, k_items = k_items, n_cases = 50)
var_error_alpha(alpha = c(alpha, alpha), k_items = c(k_items, k_items), n_cases = 50)
}
\references{
Duhachek, A., & Iacobucci, D. (2004).
Alpha’s standard error (ASE): An accurate and precise confidence interval estimate.
*Journal of Applied Psychology, 89*(5), 792–808. \doi{10.1037/0021-9010.89.5.792}
}
