% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_predicted.lm.R
\name{get_predicted.lm}
\alias{get_predicted.lm}
\title{Compute predicted values of lm models.}
\usage{
\method{get_predicted}{lm}(fit, newdata = "model", prob = 0.95, ...)
}
\arguments{
\item{fit}{An lm model.}

\item{newdata}{A data frame in which to look for variables with which to predict. If omitted, the model matrix is used. If "model", the model's data is used.}

\item{prob}{Probability of confidence intervals (0.95 (default) will compute 2.5-97.5\% CI). Can also be a list of probs (e.g., c(0.90, 0.95)).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
dataframe with predicted values.
}
\description{
Compute predicted from a lm model.
}
\examples{
\dontrun{
library(psycho)
library(ggplot2)

fit <- lm(Tolerating ~ Adjusting, data=affective)

refgrid <- psycho::refdata(affective, "Adjusting")
predicted <- get_predicted(fit, newdata=refgrid)

ggplot(predicted, aes(x=Adjusting, y=Tolerating_Predicted)) +
  geom_line() +
  geom_ribbon(aes(ymin=Tolerating_CI_2.5,
                  ymax=Tolerating_CI_97.5),
                  alpha=0.1)


}
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
