% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvPSYmc.R
\name{cvPSYmc}
\alias{cvPSYmc}
\title{Simulate the finite sample critical values for the PSY test.}
\usage{
cvPSYmc(obs, swindow0, IC = 0, adflag = 0, nrep = 199,
  multiplicity = TRUE, Tb, useParallel = TRUE, nCores)
}
\arguments{
\item{obs}{A positive integer. The number of observations.}

\item{swindow0}{A positive integer. Minimum window size (default = \eqn{T
(0.01 + 1.8/\sqrt{T})}, where \eqn{T} denotes the sample size)}

\item{IC}{An integer. 0 for fixed lag order (default), 1 for AIC and 2 for
BIC (default = 0).}

\item{adflag}{An integer, lag order when IC=0; maximum number of
lags when IC>0 (default = 0).}

\item{nrep}{A positive integer. Number of replications (default = 199).}

\item{multiplicity}{Logical. If \code{multiplicity=TRUE}, use family-wise
size control in the recursive testing algorithms.}

\item{Tb}{A positive integer. The simulated sample size (swindow0+
controlling). Ignored if \code{multiplicity=FALSE}.}

\item{useParallel}{Logical. If \code{useParallel=TRUE}, use multi core
computation.}

\item{nCores}{A positive integer. Optional. If \code{useParallel=TRUE}, the
number of cores defaults to all but one.}
}
\value{
A matrix. BSADF bootstrap critical value sequence at the 90, 95 and
  99 percent level.
}
\description{
\code{cvPSYmc} implements the real time bubble detection
  procedure of Phillips, Shi and Yu (2015a,b)
}
\examples{
cv <- cvPSYmc(80, IC = 0, adflag = 1, Tb = 30, nrep = 99, nCores = 1)
}
\references{
Phillips, P. C. B., Shi, S., & Yu, J. (2015a). Testing for
  multiple bubbles: Historical episodes of exuberance and collapse in the S&P
  500. \emph{International Economic Review}, 56(4), 1034--1078.

Phillips, P. C. B., Shi, S., & Yu, J. (2015b). Testing for
  multiple bubbles: Limit Theory for Real-Time Detectors. \emph{International
  Economic Review}, 56(4), 1079--1134.
}
