% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{alpha}
\alias{alpha}
\title{Microarray time series experiment for yeast cell cycle from alpha experiment}
\format{Matrix with 6178 rows and 18 columns.
Some missing data.
Rows and columns are labelled.
- attr(*, "dimnames")=List of 2
..$ : chr [1:6178] "YAL001C" "YAL002W" "YAL003W" "YAL004W" ...
..$ : chr [1:18] "alpha0" "alpha7" "alpha14" "alpha21" ...}
\source{
The data is extracted from the ExpressionSet of 
the R package \code{yeastCC}.
}
\usage{
data(alpha)
}
\description{
6,178 yeast genes expression measures (log-ratios) with 
series length 18 from the alpha factor experiment.
}
\examples{
data(alpha)
qqnorm(colMeans(alpha, na.rm=TRUE))
qqnorm(rowMeans(alpha, na.rm=TRUE))
}
\references{
Spellman, P. T., Sherlock, G., Zhang, M. Q., Iyer, V. R.,
 Anders, K., Eisen, M. B., ... & Futcher, B. (1998). 
 Comprehensive identification of cell cycle-regulated genes of 
 the yeast Saccharomyces cerevisiae by microarray hybridization. 
 Molecular biology of the cell, 9(12), 3273-3297.

Dudoit S (2016). yeastCC: Spellman et al. (1998) and 
Pramila/Breeden (2006) yeast cell cycle microarray data. 
R package version 1.12.0.
}
\keyword{datasets}

