% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distances.R
\name{dist2closest}
\alias{dist2closest}
\title{Search and Compute the Distance to the Closest Aa}
\usage{
dist2closest(pdb, chain, res, aa = "M", backbone = FALSE)
}
\arguments{
\item{pdb}{is either a PDB id, or the path to a pdb file.}

\item{chain}{chain ID.}

\item{res}{position of the residue of interest.}

\item{aa}{amino acid of interest.}

\item{backbone}{logical, when TRUE it means that we include those atoms belonging to the main chain (CA, N, O and C) beside all the side chain atoms.}
}
\value{
Numerical value indicating the distance in ångströms (Å).
}
\description{
Computes the distance to the closest amino acid of the indicated type
}
\details{
The identity of the closest Aa is given as an attribute.
}
\examples{
\dontrun{dist2closest(pdb = '1q8k', chain = 'A', res = 222, aa = 'S')}
}
\seealso{
res.dist(), pairwise.dist(), ball()
}
