% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_features.R
\name{idw_xy}
\alias{idw_xy}
\title{Inverse distance weighted sums}
\usage{
idw_xy(base, feat, clip = 1, weight = 1)
}
\arguments{
\item{base}{base dataset (eg gridcells), needs to be SpatialPolygonsDataFrame}

\item{feat}{feature dataset (eg another crime generator), needs to be SpatialPointsDataFrame}

\item{clip}{scaler minimum value for weight, default \code{1} (so weights cannot be below 0)}

\item{weight}{if 1 (default), does not use weights, else pass in string that is the variable name for weights in \code{feat}}
}
\value{
A vector of IDW weighted sums
}
\description{
Given a base X/Y dataset, calculates clipped inverse distance weighted sums of points from feature dataset
}
\details{
This generates a inverse distance weighted sum of features within specified distance of the \code{base} centroid.
Weights are clipped to never be below \code{clip} value, which prevents division by 0 (or division by a very small distance number)
Uses loops and calculates all pairwise distances, so can be slow for large base and feature datasets. Consider
aggregating/weighting feature dataset if it is too slow. Useful for quantifying features nearby (Groff, 2014), or for egohoods
(e.g. spatial smoothing of demographic info, Hipp & Boessen, 2013).
}
\examples{
data(nyc_cafe); data(nyc_bor)
gr_nyc <- prep_grid(nyc_bor,6000)
gr_nyc$idwcafe <- idw_xy(gr_nyc,nyc_cafe)
\donttest{
gr_nyc$idwtabl <- idw_xy(gr_nyc,nyc_cafe,weight='SWC_TABLES')
head(gr_nyc@data)
sp::spplot(gr_nyc,zcol='idwtabl') #inverse distance weighted tables
}

}
\references{
Groff, E. R. (2014). Quantifying the exposure of street segments to drinking places nearby. \emph{Journal of Quantitative Criminology}, 30(3), 527-548.

Hipp, J. R., & Boessen, A. (2013). Egohoods as waves washing across the city: A new measure of “neighborhoods”. Criminology, 51(2), 287-327.
}
\seealso{
\code{\link[=dist_xy]{dist_xy()}} for calculating distance to nearest

\code{\link[=count_xy]{count_xy()}} for counting points inside polygon

\code{\link[=kern_xy]{kern_xy()}} for estimating gaussian density of points for features at base polygon xy coords

\code{\link[=bisq_xy]{bisq_xy()}} to estimate bi-square kernel weights of points for features at base polygon xy coords

\code{\link[=idw_xy]{idw_xy()}} to estimate inverse distance weights of points for features at base polygon xy coords
}
