% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stem_rslp.R
\name{stem_rslp}
\alias{stem_rslp}
\title{Stemming using RSLP}
\usage{
stem_rslp(words, complete = TRUE)
}
\arguments{
\item{words}{character vector of words to be stemmed}

\item{complete}{wheter words must be completed or not (T)}
}
\description{
This function uses the RSLP algorithm to stem a vector of words.
By default, the RSLP algorithm leaves words cutted. As this makes
reading stemmed texts very difficult, this function provides an option
to complete the stemmed words. By default it completes with the most used
word in the text that has the same stem.
}
\examples{
words <- c("balões", "aviões", "avião", "gostou", "gosto", "gostaram")
ptstem:::stem_rslp(words)

}
\references{
V. Orengo, C. Huyck, "A Stemming Algorithmm for the Portuguese Language", SPIRE, 2001, String Processing and Information Retrieval, International Symposium on, String Processing and Information Retrieval, International Symposium on 2001, pp. 0186, doi:10.1109/SPIRE.2001.10024
}

