% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_apa.R
\name{style.apa.fisher}
\alias{style.apa.fisher}
\title{Formats a Fisher's Exact Test}
\usage{
style.apa.fisher(x, print.estimate = TRUE,
  estimate.names = names(x[[1]]$estimate))
}
\arguments{
\item{x}{a list. First item must be a Fisher's exact test (htest class).
All other list items will be ignored.}

\item{print.estimate}{a logical, indicating whether odds ratio is printed
as well.}

\item{estimate.names}{a character vector, giving a alternative name for
"odds ratio".}
}
\value{
character vector with a formatted character vector.
}
\description{
This style functions takes a Fisher's exact test in a list and transforms
it into a formatted character vector. Odds ratio is printed optionally.
}
\details{
Please note that this is a internal style function. It is called
from \code{\link{pprint}} and not exported to user namespace. Usually
\code{\link{pprint}} determines the correct style function automatically,
but you can define the style function by using the \code{format} argument
of \code{\link{pprint}} (pass the name of this function without
\code{style.apa.} prefix). Additionally you can pass the arguments listed
in this documentation to \code{\link{pprint}}.

Argument \code{x} of this function expects a list. Be aware that you do not
have to pass a list to \code{\link{pprint}} or \code{\link{pull.pubprint}}
-- these functions will convert your arguments. This is only necessary if
you want to pass additionally information to the internal style functions
(see vignette for examples).
}
\examples{
pprint(t.test(1:30, 2:31), format = "t.test")
pprint(t.test(1:30, 2:31), format = "t.test", print.estimate = FALSE)
pprint(t.test(1:30, 2:31), 
       format = "t.test", 
       estimate.names = c("control", "treatment"))
TeaTasting <-
matrix(c(3, 1, 1, 3),
       nrow = 2,
       dimnames = list(Guess = c("Milk", "Tea"),
                       Truth = c("Milk", "Tea")))
pprint(fisher.test(TeaTasting, alternative = "greater"),
       format = "fisher")
pprint(fisher.test(TeaTasting, alternative = "greater"),
       format = "fisher",
       print.estimate = FALSE)
}
\seealso{
\code{\link[stats]{fisher.test}}

Other APA.style.functions: \code{\link{style.apa.anova}},
  \code{\link{style.apa.bartlett}},
  \code{\link{style.apa.character}},
  \code{\link{style.apa.chisq}},
  \code{\link{style.apa.cor.test}},
  \code{\link{style.apa.df}}, \code{\link{style.apa.ks}},
  \code{\link{style.apa.numeric}},
  \code{\link{style.apa.p.value}},
  \code{\link{style.apa.shapiro}},
  \code{\link{style.apa.summary.aovlist}},
  \code{\link{style.apa.summary.lm.beta.coeff}},
  \code{\link{style.apa.summary.lm.coeff}},
  \code{\link{style.apa.summary.lm.equation}},
  \code{\link{style.apa.summary.lm.model}},
  \code{\link{style.apa.t.test}}
}

