% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected.R
\encoding{UTF-8}
\name{exp_g}
\alias{exp_g}
\title{Expected purged inbreeding coefficient}
\usage{
exp_g(Ne, t, d)
}
\arguments{
\item{Ne}{Effective population size}

\item{t}{Generation number}

\item{d}{Purging coefficient (taking values between 0.0 and 0.5).}
}
\value{
The purged inbreeding coefficient
}
\description{
Estimates the expected purged inbreeding coefficient (g) as a function of the effective population size, generation number, and purging coefficient
}
\details{
Computation of the purged inbreeding coefficient is calculated as in García-Dorado (2012):

g(t) = [ (1 - 1/2N) g(t-1)  + 1/2N] * [1 - 2d F(t-1)]

When convergence is reached, the asymptotic value g(a) is returned:

g(a) = (1 - 2d) / (1 + 2d (2N-1))
}
\examples{
exp_g(Ne = 50, t = 0, d = 0.15)
exp_g(Ne = 50, t = 50, d = 0.15)
exp_g(Ne = 10, t = 50, d = 0.15)
}
\references{
\itemize{
  \item{García-Dorado. 2012. Understanding and predicting the fitness decline of shrunk populations: Inbreeding, purging, mutation, and standard selection. Genetics 190: 1-16.}
}
}
\seealso{
\code{\link{ip_g}}
}
