% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/map-vector.R
\name{flatmap}
\alias{flatmap}
\title{Map a function and flatten the result by one-level}
\usage{
flatmap(.x, .f, ..., .type)
}
\arguments{
\item{.x}{A list or vector.}

\item{.f}{A function, formula or string.

  If a function, it is used as is.

  If a formula, e.g. \code{~ .x + 2}, it is converted to a function with
  a three arguments, \code{.x} or \code{.}, \code{.y}, \code{.z}. This allows
  you to create very compact anonymous functions of up to 3 variables.

  If a string, e.g. \code{"y"}, it is converted to an extractor function,
  \code{function(x) x[["y"]]}.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{.type}{A string indicating which type you expect the results
of \code{.f} should be. This can be any of the types returned by
\code{\link{typeof}()}, or "numeric" as a shorthand for either
"double" or "integer".}
}
\description{
\code{flatmap()} is equivalent to \code{map()} followed by
\code{flatten()}. You can also provide \code{.type} to check the
resulting type conforms to you expectations.
}
\details{
Compared to \code{\link{map_lgl}()}, \code{\link{map_chr}()}, etc,
\code{flatmap()} is adapted to functions returning a variable
number of elements.
}
\examples{
# Sample a variable number of elements from each column and
# concatenate the results
var_select <- function(x) sample(x, size = rdunif(1, 5))
c(mtcars) \%>\% flatmap(var_select)

# You can also check that the results are of expected type
\dontrun{
c(mtcars) \%>\% flatmap(var_select, .type = "character")
}
c(mtcars) \%>\% flatmap(var_select, .type = "numeric")
}
\seealso{
\code{\link{map_lgl}()}, \code{\link{map_chr}()},
  \code{\link{map_dbl}()}, \code{\link{map_int}()}
}

