% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_subscription.R
\name{group_subscription}
\alias{group_add_user}
\alias{group_delete_user}
\alias{group_disable_user}
\alias{group_enable_user}
\alias{group_subscription}
\title{Manage group subscriptions}
\usage{
group_subscription(cmd, ...)

group_add_user(group, user, app = get_pushover_app(), device = NULL,
  memo = NULL)

group_delete_user(group, user, app = get_pushover_app())

group_disable_user(group, user, app = get_pushover_app())

group_enable_user(group, user, app = get_pushover_app())
}
\arguments{
\item{cmd}{The group subscription command to execute}

\item{...}{Specific arguments for the given group subscription command}

\item{group}{group key}

\item{user}{user key}

\item{app}{application token (see \code{\link{set_pushover_app}})}

\item{device}{(optional) device name to receive messages (defaults to all devices)}

\item{memo}{(optional) memo about the user}
}
\value{
An invisible list containing the following fields:
\itemize{
    \item \code{status}: request status (1 = success)
    \item \code{request}: unique request ID
    \item \code{raw}: the raw \code{\link[httr]{response}} object
}
}
\description{
These functions manage a user's membershop in a Pushover delivery group

\code{group_add_user} adds a user to a group. Optionally, a
device can be specified on which that user will receive notifications

\code{group_delete_user} removes a user from a group

\code{group_disable_user} temporarily disables a user from
receiving group notifications.

\code{group_enable_user} re-enables a user to receive group
notifications for a group
}
\examples{
\dontrun{
group_add_user(group = "gznej3rKEVAvPUxu9vvNnqpmZpokzF",
               user = "uQiRzpo4DXghDmr9QzzfQu27cmVRsG",
               device = "phone")
}
\dontrun{
group_delete_user(group = "gznej3rKEVAvPUxu9vvNnqpmZpokzF",
                  user = "uQiRzpo4DXghDmr9QzzfQu27cmVRsG")
}
\dontrun{
group_disable_user(group = "gznej3rKEVAvPUxu9vvNnqpmZpokzF",
                   user = "uQiRzpo4DXghDmr9QzzfQu27cmVRsG")
}
\dontrun{
group_enable_user(group = "gznej3rKEVAvPUxu9vvNnqpmZpokzF",
                  user = "uQiRzpo4DXghDmr9QzzfQu27cmVRsG")
}
}

