% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/px.R
\name{px_save}
\alias{px_save}
\title{Save px object to file}
\usage{
px_save(x, path, save_data = TRUE, data_path = NULL)
}
\arguments{
\item{x}{A px object.}

\item{path}{Path to file. The file extension determines the format. Can be:
\itemize{
\item \code{.px} to save as a PX-file
\item \code{.xlsx} to save as an Excel workbook
\item \code{.R} to save an R-script that creates the px object
}}

\item{save_data}{If FALSE, no 'Data' sheet is created in the Excel workbook.
Can only be used if \code{path} is an \code{.xlsx} file.}

\item{data_path}{Path to an \code{.rds} or \code{.parquet} file to save data table at.
Can only be used if \code{path} is an \code{.xlsx} or \code{.R} file, and \code{save_data} is
\code{TRUE}.}
}
\value{
Nothing
}
\description{
Save px object to file
}
\details{
Use \code{px_codepage()} to change file encoding.
}
\examples{

# Save px object to PX-file
tmp_dir <- tempdir()

x <- px(population_gl)

px_save(x, file.path(tmp_dir, "population.px"))

# Save px object to Excel workbook
px_save(x, file.path(tmp_dir, "population.xlsx"))

# Save px object as R-script that creates the px object
px_save(x, file.path(tmp_dir, "population.R"))

}
\seealso{
\code{\link[=px_codepage]{px_codepage()}}
}
