% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/px.R
\name{px}
\alias{px}
\title{Create a px object}
\usage{
px(input = NULL, data = NULL, validate = TRUE)
}
\arguments{
\item{input}{Optional character string. Can be:
\itemize{
\item Path to a PX-file
\item Path to an Excel metadata workbook
\item A data frame
\item Path to an \code{.rds} or \code{.parquet} file with a data frame
\item URL of a PX-file
}

If input is a data frame or NULL, a px object with minimal metadata is created.}

\item{data}{Either a data frame or a path to an \code{.rds} or \code{.parquet} file
with a data frame. This can only be used if \code{input} is an Excel metadata
workbook.}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object
}
\description{
Create a px object from a PX-file, an Excel metadata workbook, or a data
frame.
}
\examples{
# Create px object from dataset
x1 <- px(population_gl)

# Download PX-file for example
download_succeeded <- tryCatch({
  px_path <- tempfile(fileext = ".px")
  url <- "https://bank.stat.gl:443/sq/0cf06962-19f1-4d5c-8d43-b7ed0009617d"
  download.file(url, px_path)
  TRUE
}, error = function(e) FALSE)

# Run examples only if file was downloaded
if (download_succeeded) {
  # Create px object from PX-file
  x2 <- px(px_path)

  # Create px object from URL
  x3 <- px(url)
}

# Create minimal px object
x4 <- px()

}
