% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{heatmap.qad}
\alias{heatmap.qad}
\title{Heatmap of dependence measures}
\usage{
heatmap.qad(pw_qad, select = c("dependence", "mean.dependence",
  "asymmetry"), fontsize = 4, significance = FALSE,
  sign.level = 0.05, scale = "abs", color = "plasma",
  rb_values = c(10, 0.315, 0.15))
}
\arguments{
\item{pw_qad}{output of the function \code{pairwise.qad}().}

\item{select}{a character indicating which dependence value is plotted.
Options are c("dependence", "mean.dependence", "asymmetry").}

\item{fontsize}{a numeric specifying the font size of the values.}

\item{significance}{a logical indicating whether significant values - with respect to the permutated p.values - are marked with a star.}

\item{sign.level}{numeric value indicating the significance level.}

\item{scale}{character indicating whether the heatmap uses a relative or absolute scale. Options are "rel" or "abs" (default).}

\item{color}{Select the color palette. Options are c("plasma" (default), "viridis", "inferno", "magma", "cividis").}

\item{rb_values}{a vector of size 3 with number of values, start value and end value in the rainbow colors space.}
}
\value{
a heatmap
}
\description{
The pairwise computed dependence measures (output of the function \code{pairwise.qad()}) are illustrated by a heatmap.
}
\details{
If the output of \code{pairwise.qad}() contains p-values, significant values can be highlighted by stars by setting significance=TRUE.
}
\examples{
n <- 1000
x <- runif(n, 0, 1)
y <- x^2 + rnorm(n, 0, 1)
z <- runif(n, 0, 1)
sample_df <- data.frame(x, y, z)

#qad (Not Run)
#model <- pairwise.qad(sample_df, permutation = TRUE, nperm = 10, DoParallel = TRUE)
#heatmap.qad(model, select = "dependence", fontsize = 6, significance = TRUE)
}
