% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qad.R
\name{qad}
\alias{qad}
\alias{qad.data.frame}
\alias{qad.numeric}
\title{Measure of (asymmetric and directed) dependence}
\usage{
qad(x, ...)

\method{qad}{data.frame}(
  x,
  resolution = NULL,
  permutation = FALSE,
  nperm = 1000,
  DoParallel = TRUE,
  registerC = registerDoParallel,
  ncores = NULL,
  print = TRUE,
  remove.00 = FALSE,
  ...
)

\method{qad}{numeric}(
  x,
  y,
  resolution = NULL,
  permutation = FALSE,
  nperm = 1000,
  DoParallel = TRUE,
  registerC = registerDoParallel,
  ncores = NULL,
  print = TRUE,
  remove.00 = FALSE,
  ...
)
}
\arguments{
\item{x}{a data.frame containing two columns with the observations of the bivariate sample or a (non-empty) numeric vector of data values}

\item{...}{Further arguments passed to 'qad' will be ignored}

\item{resolution}{an integer indicating the number of strips for the checkerboard aggregation (see \link{emp_c_copula}).
Default = NULL uses the optimal resolution.}

\item{permutation}{a logical indicating whether a p-value (based on permutations) is computed; otherwise a p-value is computed on MC-simulations (see pqad()).}

\item{nperm}{an integer indicating the number of permutation runs.}

\item{DoParallel}{a logical value indicating whether the repetitions in the permutation test is computed parallel.}

\item{registerC}{function to register the parallel environment. It is recommended to use registerDoParallel(), contained in the doParallel package (default). Another option, especially for a linux based system, is to install the
doMC package and use registerDoMC}

\item{ncores}{an integer indicating the number of cores used for parallel computation. (Default = NULL, which is defined by max(cores)-1)}

\item{print}{a logical indicating whether the result of qad is printed.}

\item{remove.00}{a logical indicating whether double 0 entries should be excluded (default = FALSE)}

\item{y}{a (non-empty) numeric vector of data values.}
}
\value{
qad returns an object of class qad containing the following components:
\item{data}{ a data.frame containing the input data.}
\item{results}{ a data.frame containing the results of the dependence measures.}
\item{mass_matrix}{ a matrix containing the mass distribution of the empirical checkerboard copula.}
\item{resolution}{an integer containing the used resolution of the checkerboard aggregation.}
}
\description{
Quantification of (asymmetric and directed) dependence structures between two random variables X and Y.
}
\details{
qad is the implementation of a strongly consistent estimator of the copula based dependence measure zeta_1 introduced in Trutschnig 2011.
We first compute the empirical copula of a two-dimensional sample, aggregate it to the so called empirical checkerboard copula (ECB), and
calculate zeta_1 of the ECB copula and its transpose. In order to test for independence (in both directions), the distribution (and hence the p-value)
of a Monte-Carlo simulation is provided (default). Alternatively, a permutation test can be used to obtain p-values for the direction and asymmetry.
}
\note{
The computation of the p-values (aggregated by permutations) take some time.
}
\examples{
#Example 1 (independence)

n <- 1000
x <- runif(n,0,1)
y <- runif(n,0,1)
sample <- data.frame(x,y)
qad(sample)

###

#Example 2 (mutual complete dependence)

n <- 1000
x <- runif(n,0,1)
y <- x^2
sample <- data.frame(x,y)
qad(sample)

#Example 3 (complete dependence)

n <- 1000
x <- runif(n,-10,10)
y <- sin(x)
sample <- data.frame(x,y)
qad(sample)
}
\references{
Trutschnig, W. (2011). On a strong metric on the space of copulas and its induced dependence measure, Journal of Mathematical Analysis and Applications 384, 690-705.
}
