% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcs.pcr.r
\name{qcs.pcr}
\alias{qcs.pcr}
\title{Process capability indices for a given dataset and distribution}
\usage{
qcs.pcr(
  object,
  distribution = c("normal", "beta", "chi-squared", "exponential", "f", "geometric",
    "lognormal", "log-normal", "logistic", "t", "negative binomial", "poisson",
    "weibull", "gamma"),
  limits = c(lsl = -3, usl = 3),
  target = NULL,
  std.dev = NULL,
  boxcox = FALSE,
  lambda = c(-5, 5),
  confidence = 0.9973,
  plot = TRUE,
  main = NULL,
  ...
)
}
\arguments{
\item{object}{qcs object of type \code{"qcs.xbar"} or \code{"qcs.one"}.}

\item{distribution}{character string that representing the probability distribution the data, such as:"normal","beta", "chi-squared", 
"exponential", "f", "geometric", "lognormal", "log-normal", "logistic","t",
"negative binomial", "poisson", "weibull", "gamma".}

\item{limits}{A vector specifying the lower and upper specification limits.}

\item{target}{A value specifying the target of the process. 
If is \code{NULL}, the target is set at the middle value bewteen specification limits.}

\item{std.dev}{A value specifying the within-group standard deviation.}

\item{boxcox}{Logical value (default is FALSE). If TRUE, perform a Box-Cox transformation.}

\item{lambda}{A vector specifying or numeric value indicating lambda for the transformation}

\item{confidence}{A numeric value between 0 and 1 specifying the nivel for computing the specification limits.}

\item{plot}{Logical value indicating whether graph should be plotted.}

\item{main}{Title of the plot.}

\item{...}{Arguments to be passed to or from methods.}
}
\description{
Calculates the process capability indices cp, cpk, cpkL and cpkU for a given dataset and distribution. 
A histogramm with a density curve is displayed along with the specification limits and a 
Quantile-Quantile Plot for the specified distribution.
}
\examples{
library(qcr)
data(pistonrings) 
xbar <- qcs.xbar(pistonrings[1:125,],plot = TRUE)
limits = c(lsl = 73.99, usl = 74.01)
qcs.pcr(xbar, "normal", limits = limits) 
qcs.pcr(xbar, "weibull", limits = limits)
}
\references{
Montgomery, D.C. (1991) \emph{Introduction to Statistical Quality Control}, 2nd
ed, New York, John Wiley & Sons. \cr
}
