\name{termco.c}
\alias{termco.c}
\title{Combine Columns from a termco Object}
\usage{
  termco.c(termco.object, combined.columns, new.name,
    short.term = TRUE, zero.replace = NULL,
    elim.old = TRUE, percent = NULL, digits = 2)
}
\arguments{
  \item{termco.object}{An object generated by either
  \code{\link[qdap]{termco}}, \code{\link[qdap]{termco.d}}
  or \code{\link[qdap]{termco.c}}.}

  \item{combined.columns}{The names/indexes of the columns
  to be combined.}

  \item{new.name}{A character vector of length one to name
  the new combined column.}

  \item{short.term}{logical.  If TRUE column names are
  trimmed versions of the match list, otherwise the terms
  are wrapped with 'term(phrase)'}

  \item{zero.replace}{Value to replace zeros with.}

  \item{elim.old}{logical.  If TRUE eliminates the columns
  that are combined together by the named match.list.}

  \item{percent}{logical.  If TRUE output given as percent.
  If FALSE the output is proportion.}

  \item{digits}{Integer; number of decimal places to round
  when printing.}
}
\value{
  Returns a return a list, of class \code{"termco"}, of
  data frames and information regarding word counts:
  \item{raw}{raw word counts by grouping variable}
  \item{prop}{proportional word counts by grouping
  variable; proportional to each individual's word use}
  \item{rnp}{a character combination data frame of raw and
  proportional} \item{zero_replace}{value to replace zeros
  with; mostly internal use} \item{percent}{The value of
  percent used for plotting purposes.}
  \item{digits}{integer value od number of digits to
  display; mostly internal use}
}
\description{
  Combines the columns of a termco object.  Generally
  intended for internal use but documented for
  completeness.
}
\seealso{
  \code{\link[qdap]{termco}}
}

