% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot.formality}
\alias{plot.formality}
\title{Plots a formality Object}
\usage{
\method{plot}{formality}(x, point.pch = 20, point.cex = 0.5,
  point.colors = c("gray65", "red"), bar.colors = NULL,
  short.names = TRUE, min.wrdcnt = NULL, order.by.formality = TRUE,
  plot = TRUE, ...)
}
\arguments{
\item{x}{The formality object.}

\item{point.pch}{The plotting symbol.}

\item{point.cex}{The plotting symbol size.}

\item{point.colors}{A vector of colors (length of two) to plot word count and
formality score.}

\item{bar.colors}{A palette of colors to supply to the bars in the
visualization.  If two palettes are provided to the two bar plots
respectively.}

\item{short.names}{logical.  If TRUE shortens the length of legend and label
names for more compact plot width.}

\item{min.wrdcnt}{A minimum word count threshold that must be achieved to be
considered in the results.  Default includes all subgroups.}

\item{order.by.formality}{logical.  If \code{TRUE} the group formality plot
will be ordered by average formality score, otherwise alphabetical order is
assumed.}

\item{plot}{logical.  If \code{TRUE} the plot will automatically plot.
The user may wish to set to \code{FALSE} for use in knitr, sweave, etc.
to add additional plot layers.}

\item{\ldots}{ignored}
}
\value{
Invisibly returns the \code{ggplot2} objects that form the larger
plot.
}
\description{
Plots a formality object including the parts of speech used to
calculate contextual/formal speech.
}

