% Generated by roxygen2 (4.0.2): do not edit by hand
\name{check_spelling_interactive.check_spelling}
\alias{check_spelling_interactive.check_spelling}
\title{Check Spelling}
\usage{
\method{check_spelling_interactive}{check_spelling}(text.var, range = 2,
  assume.first.correct = TRUE, click = TRUE, method = "jw",
  dictionary = qdapDictionaries::GradyAugmented, parallel = TRUE,
  cores = parallel::detectCores()/2, n.suggests = 8, ...)
}
\arguments{
\item{text.var}{A \code{\link[qdap]{check_spelling}} object.}

\item{range}{An integer of length 1 to use as a range for number of
characters, beyond the number of characters of a word not found in the
\code{dictionary}, to initially limit \code{dictionary} size and thus time to
find a suggested replacement term.  This may be expanded if no suitable
suggestion is returned.}

\item{assume.first.correct}{logical.  If \code{TRUE} it is assumed that the
first letter of the misspelled word is correct.  This reduces the dictionary
size, thus speeding up computation.}

\item{click}{logical.  If \code{TRUE} the interface is a point and click GUI.
If \code{FALSE} the interface is command line driven.}

\item{method}{Method for distance calculation. The default is "jaccard".  It
is assumed that smaller measures indicate closer distance.  Measures that do
not adhere to this assumption will result in incorrect output (see
\code{\link[stringdist]{stringdist}} for details).}

\item{dictionary}{A character vector of terms to search for.  To reduce
overhead it is expected that this dictionary is lower case, unique terms.}

\item{parallel}{logical.  If \code{TRUE} attempts to run the function on
multiple cores.  Note that this may not mean a speed boost if you have one
core or if the data set is smaller as the cluster takes time to create.}

\item{cores}{The number of cores to use if \code{parallel = TRUE}.  Default
is half the number of available cores.}

\item{n.suggests}{The number of terms to suggest.  In the case of a tie
(multiple terms have the same distance from misspelled word) all will be provided.
Dictionary reduction may result in less than \code{n.suggests} suggested terms.}

\item{\ldots}{ignored}
}
\description{
View check_spelling check_spelling_interactive.
}
\details{
check_spelling Method for check_spelling_interactive
}

