% Generated by roxygen2 (4.0.2): do not edit by hand
\name{subject_pronoun_type}
\alias{subject_pronoun_type}
\title{Count Subject Pronouns Per Grouping Variable}
\usage{
subject_pronoun_type(text.var, grouping.var = NULL,
  subject.pronoun.list = NULL, ...)
}
\arguments{
\item{text.var}{The text variable}

\item{grouping.var}{The grouping variables.  Default \code{NULL} generates
one word list for all text.  Also takes a single grouping variable or a list
of 1 or more grouping variables.}

\item{subject.pronoun.list}{A named list of subject pronouns.  See
\strong{Details} for more.}

\item{\ldots}{Other arguments passed to \code{\link[qdap]{termco}}}
}
\value{
Returns a list, of class "subject_pronoun_type", of data frames
regarding subject pronoun word counts:
\item{preprocessed}{List of uncollapsed dataframes (raw, prop, rnp) of the class "termco" that contain all searchable subject pronouns.}
\item{raw}{raw word counts by grouping variable}
\item{prop}{proportional word counts by grouping variable; proportional to
each individual's subject pronoun use}
\item{rnp}{a character combination data frame of raw and proportional subject pronoun use}
}
\description{
Count the number of subject pronouns per grouping variables.
}
\details{
The following subject pronoun categories are the default searched terms:
\itemize{
    \item I - c(" i'd ", " i'll ", " i'm ", " i've ", " i ")
    \item we - c(" we'd ", " we'll ", " we're ", " we've ", " we ")
    \item you - c(" you'd ",  " you'll ", " you're ", " you've ", " you ", " your ")
    \item he - c(" he'd ", " he'll ", " he's ", " he ")
    \item she - c(" she'd ", " she'll ", " she's ", " she ")
    \item it - c(" it'd ", " it'll ", " it's ", " it ")
    \item they - c(" they'd ", " they'll ", " they're ", "they've ", " they ")
}
}
\examples{
\dontrun{
dat <- pres_debates2012
dat <- dat[dat$person \%in\% qcv(ROMNEY, OBAMA), ]
(out <- subject_pronoun_type(dat$dialogue, dat$person))
plot(out)
plot(out, 2)
plot(out, 3)
plot(out, 3, ncol=2)

scores(out)
counts(out)
proportions(out)
preprocessed(out)

plot(scores(out))
plot(counts(out))
plot(proportions(out))
}
}
\seealso{
\code{\link[qdap]{object_pronoun_type}},
\code{\link[qdap]{pronoun_type}}
}
\keyword{pronouns}

