% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rm_caps}
\alias{rm_caps}
\title{Remove/Replace/Extract All Caps}
\usage{
rm_caps(text.var, trim = !extract, clean = TRUE, pattern = "@rm_caps",
  replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_caps} uses the
\code{rm_caps} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the all caps strings are extracted
into a list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with "all caps" removed.
}
\description{
Remove/replace/extract 'all caps' words containing 2 or more consecutive
upper case letters from a string.
}
\examples{
x <- c("UGGG! When I use caps I am YELLING!")
rm_caps(x)
rm_caps(x, replacement="\\\\L\\\\1")
rm_caps(x, extract=TRUE)
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}
}
\keyword{capital}
\keyword{caps}

