% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rm_title_name}
\alias{rm_title_name}
\title{Remove/Replace/Extract Title + Person Name}
\usage{
rm_title_name(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_title_name", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_title_name} uses the
\code{rm_title_name} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the person tags are extracted into a
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with person tags removed.
}
\description{
Remove/replace/extract title (honorific) + person name(s) from a string.
}
\examples{
x <- c("Dr. Brend is mizz hart's in mrs. Holtz's.",
    "Where is mr. Bob Jr. and Ms. John Kennedy?")

rm_title_name(x)
rm_title_name(x, extract=TRUE)
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}
}
\keyword{person}
\keyword{tag}
\keyword{twitter}

