% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_surv.R
\name{qgcomp.survcurve.boot}
\alias{qgcomp.survcurve.boot}
\title{Survival curve data from a qgcomp survival fit}
\usage{
qgcomp.survcurve.boot(x, ...)
}
\arguments{
\item{x}{a \code{qgcompfit} object from \code{\link[qgcomp]{qgcomp.cox.boot}}}

\item{...}{not used}
}
\value{
a list of data.frames:
#'  \itemize{
\item{'mdfpop': }{Average Survival curve (survival, time) based on
marginal structural model, averaged over the population at every quantile
of exposure}
\item{'cdfpop': }{Population average survival curve (survival, time) based on
the underlying conditional model}
\item{'mdfq': }{Survival curves (survival, time) for each quantile
based on marginal structural model}
\item{'cdfq': }{Survival curves (survival, time) for each quantile
based on underlying conditional model}
}
}
\description{
It is often of interest to examine survival curves from qgcomp.cox.boot
models. They can be useful for checking assumptions about how well
the marginal structural model conforms to the underlying conditional
model, such that the overall fit approximates the non-linearity
in the underlying model. This function will yield survival curves,
but no measures of uncertainty.
}
\examples{
set.seed(50)
N=200
dat <- data.frame(time=(tmg <- pmin(.1,rweibull(N, 10, 0.1))), 
                  d=1.0*(tmg<0.1), x1=runif(N), x2=runif(N), z=runif(N))
expnms=paste0("x", 1:2)
f = survival::Surv(time, d)~x1 + x2
(fit1 <- survival::coxph(f, data = dat))
(obj <- qgcomp.cox.noboot(f, expnms = expnms, data = dat))
## Not run: 
\dontrun{
(obj2 <- qgcomp.cox.boot(f, expnms = expnms, data = dat, B=10, MCsize=20000))
curves = cox.survcurve.boot(obj2)
rbind(head(curves$mdfq),tail(curves$mdfq))
}


}
